<div class="bg-white p-6 rounded-lg shadow-md">
    <h3 class="text-lg font-semibold text-gray-800 mb-4">My Specimens</h3>

    <div class="overflow-x-auto">
        <table class="w-full">
            <thead>
                <tr class="bg-gray-50">
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Barcode</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Type</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Location</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Received</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Status</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Volume</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($specimens as $specimen): ?>
                    <tr class="border-t">
                        <td class="px-4 py-3"><?php echo htmlspecialchars($specimen['barcode']); ?></td>
                        <td class="px-4 py-3"><?php echo htmlspecialchars($specimen['sample_type']); ?></td>
                        <td class="px-4 py-3"><?php echo htmlspecialchars($specimen['box_name'] . ' - ' . $specimen['row_index'] . '-' . $specimen['col_index']); ?></td>
                        <td class="px-4 py-3"><?php echo date('M j, Y', strtotime($specimen['received_at'])); ?></td>
                        <td class="px-4 py-3">
                            <span class="px-2 py-1 rounded-full text-xs <?php
                                switch ($specimen['status']) {
                                    case 'Stored': echo 'bg-green-100 text-green-800'; break;
                                    case 'Shipped': echo 'bg-blue-100 text-blue-800'; break;
                                    case 'Destroyed': echo 'bg-red-100 text-red-800'; break;
                                }
                            ?>">
                                <?php echo htmlspecialchars($specimen['status']); ?>
                            </span>
                        </td>
                        <td class="px-4 py-3"><?php echo htmlspecialchars($specimen['volume']); ?> ml</td>
                    </tr>
                <?php endforeach; ?>
                <?php if (empty($specimens)): ?>
                    <tr>
                        <td colspan="6" class="px-4 py-3 text-center text-gray-500">No specimens found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
