<div class="bg-white p-6 rounded-lg shadow-md">
    <h3 class="text-lg font-semibold text-gray-800 mb-4">Billing Information</h3>

    <!-- Current Balance -->
    <div class="bg-gray-50 p-4 rounded-lg mb-6">
        <h4 class="font-semibold mb-2">Current Balance</h4>
        <p class="text-3xl font-bold text-green-600">$<?php echo number_format($balance['total_balance'], 2); ?></p>
        <p class="text-sm text-gray-500 mt-1">Based on <?php echo count($balance['specimens']); ?> active specimens</p>
    </div>

    <!-- Billing Breakdown -->
    <div class="overflow-x-auto mb-6">
        <h4 class="font-semibold mb-3">Billing Breakdown</h4>
        <table class="w-full">
            <thead>
                <tr class="bg-gray-50">
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Specimen</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Type</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Days</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Rate</th>
                    <th class="px-4 py-2 text-left text-sm font-medium text-gray-500">Cost</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($balance['specimens'] as $specimen): ?>
                    <tr class="border-t">
                        <td class="px-4 py-3"><?php echo htmlspecialchars($specimen['barcode']); ?></td>
                        <td class="px-4 py-3"><?php echo htmlspecialchars($specimen['sample_type']); ?></td>
                        <td class="px-4 py-3"><?php echo $specimen['days_stored']; ?></td>
                        <td class="px-4 py-3">$<?php echo number_format($specimen['daily_rate'], 2); ?>/day</td>
                        <td class="px-4 py-3">$<?php echo number_format($specimen['cost'], 2); ?></td>
                    </tr>
                <?php endforeach; ?>
                <?php if (empty($balance['specimens'])): ?>
                    <tr>
                        <td colspan="5" class="px-4 py-3 text-center text-gray-500">No active specimens for billing</td>
                    </tr>
                <?php endif; ?>
            </tbody>
            <tfoot>
                <tr class="bg-gray-50 font-semibold">
                    <td colspan="4" class="px-4 py-3 text-right">Total:</td>
                    <td class="px-4 py-3">$<?php echo number_format($balance['total_balance'], 2); ?></td>
                </tr>
            </tfoot>
        </table>
    </div>

    <!-- Invoices -->
    <div>
        <h4 class="font-semibold mb-3">Invoice History</h4>
        <div class="bg-gray-50 p-4 rounded-lg">
            <p class="text-gray-600">Your invoice history would be displayed here.</p>
            <p class="text-sm text-gray-500 mt-1">In a complete implementation, this would show past invoices with dates and payment status.</p>
        </div>
    </div>
</div>
