<div class="bg-white p-6 rounded-lg shadow-md mb-8">
    <h3 class="text-lg font-semibold text-gray-800 mb-4">Storage Management</h3>

    <!-- Search Form -->
    <div class="mb-6">
        <form action="/search" method="POST" class="flex gap-2">
            <input type="text" name="barcode" placeholder="Search by barcode..." class="flex-1 px-3 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" required>
            <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition">Search</button>
        </form>
    </div>

    <!-- Search Result -->
    <?php if (isset($_SESSION['search_result'])): ?>
        <div class="bg-gray-50 p-4 rounded-lg mb-6">
            <h4 class="font-semibold mb-2">Search Result</h4>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <p><strong>Barcode:</strong> <?php echo htmlspecialchars($_SESSION['search_result']['specimen']['barcode']); ?></p>
                    <p><strong>Sample Type:</strong> <?php echo htmlspecialchars($_SESSION['search_result']['specimen']['sample_type']); ?></p>
                    <p><strong>Status:</strong> <?php echo htmlspecialchars($_SESSION['search_result']['specimen']['status']); ?></p>
                    <p><strong>Received:</strong> <?php echo date('M j, Y', strtotime($_SESSION['search_result']['specimen']['received_at'])); ?></p>
                </div>
                <div>
                    <p><strong>Location:</strong> <?php echo htmlspecialchars($_SESSION['search_result']['location']); ?></p>
                    <p><strong>Volume:</strong> <?php echo htmlspecialchars($_SESSION['search_result']['specimen']['volume']); ?> ml</p>
                </div>
            </div>
        </div>
        <?php unset($_SESSION['search_result']); ?>
    <?php endif; ?>

    <!-- Store Specimen Form -->
    <div class="bg-gray-50 p-4 rounded-lg mb-6">
        <h4 class="font-semibold mb-4">Store New Specimen</h4>
        <form action="/store-specimen" method="POST" class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label for="barcode" class="block text-sm font-medium text-gray-700 mb-1">Barcode</label>
                <input type="text" id="barcode" name="barcode" class="w-full px-3 py-2 border rounded-lg" required>
            </div>

            <div>
                <label for="client_id" class="block text-sm font-medium text-gray-700 mb-1">Client ID</label>
                <input type="number" id="client_id" name="client_id" class="w-full px-3 py-2 border rounded-lg" required>
            </div>

            <div>
                <label for="position_id" class="block text-sm font-medium text-gray-700 mb-1">Position ID</label>
                <input type="number" id="position_id" name="position_id" class="w-full px-3 py-2 border rounded-lg" required>
            </div>

            <div>
                <label for="sample_type" class="block text-sm font-medium text-gray-700 mb-1">Sample Type</label>
                <select id="sample_type" name="sample_type" class="w-full px-3 py-2 border rounded-lg" required>
                    <option value="Plasma">Plasma</option>
                    <option value="Tissue">Tissue</option>
                    <option value="Blood">Blood</option>
                    <option value="DNA">DNA</option>
                    <option value="RNA">RNA</option>
                </select>
            </div>

            <div>
                <label for="volume" class="block text-sm font-medium text-gray-700 mb-1">Volume (ml)</label>
                <input type="number" step="0.01" id="volume" name="volume" class="w-full px-3 py-2 border rounded-lg" required>
            </div>

            <div>
                <label for="disease_ontology" class="block text-sm font-medium text-gray-700 mb-1">Disease Ontology</label>
                <input type="text" id="disease_ontology" name="disease_ontology" class="w-full px-3 py-2 border rounded-lg">
            </div>

            <div class="md:col-span-2">
                <button type="submit" class="bg-green-600 text-white px-4 py-2 rounded-lg hover:bg-green-700 transition">Store Specimen</button>
            </div>
        </form>
    </div>
</div>

<!-- Storage Visualization -->
<div class="bg-white p-6 rounded-lg shadow-md">
    <h3 class="text-lg font-semibold text-gray-800 mb-4">Storage Hierarchy</h3>

    <!-- This would be replaced with actual storage visualization in a real implementation -->
    <div class="bg-gray-50 p-4 rounded-lg text-center">
        <p class="text-gray-600">Storage hierarchy visualization would be displayed here.</p>
        <p class="text-sm text-gray-500 mt-2">In a complete implementation, this would show the Room → Freezer → Shelf → Box → Position hierarchy with color-coded status indicators.</p>
    </div>
</div>
