<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
    <!-- Storage Statistics -->
    <div class="bg-white p-6 rounded-lg shadow-md">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">Storage Overview</h3>
        <div class="space-y-3">
            <div class="flex justify-between">
                <span class="text-gray-600">Total Rooms:</span>
                <span class="font-semibold"><?php echo $totalRooms; ?></span>
            </div>
            <div class="flex justify-between">
                <span class="text-gray-600">Storage Units:</span>
                <span class="font-semibold"><?php echo $totalStorageUnits; ?></span>
            </div>
            <div class="flex justify-between">
                <span class="text-gray-600">Total Boxes:</span>
                <span class="font-semibold"><?php echo $totalBoxes; ?></span>
            </div>
            <div class="flex justify-between">
                <span class="text-gray-600">Occupied Positions:</span>
                <span class="font-semibold text-green-600"><?php echo $occupiedPositions; ?></span>
            </div>
            <div class="flex justify-between">
                <span class="text-gray-600">Empty Positions:</span>
                <span class="font-semibold text-blue-600"><?php echo $emptyPositions; ?></span>
            </div>
        </div>
    </div>

    <!-- Billing Rates -->
    <div class="bg-white p-6 rounded-lg shadow-md">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">Billing Rates</h3>
        <div class="space-y-3">
            <?php foreach ($billingRates as $rate): ?>
                <div class="flex justify-between">
                    <span class="text-gray-600"><?php echo htmlspecialchars($rate['sample_type']); ?>:</span>
                    <span class="font-semibold">$<?php echo number_format($rate['daily_rate'], 2); ?>/day</span>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="bg-white p-6 rounded-lg shadow-md">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">Quick Actions</h3>
        <div class="space-y-3">
            <a href="/admin/storage" class="block w-full text-center bg-blue-600 text-white py-2 px-4 rounded hover:bg-blue-700 transition">Manage Storage</a>
            <a href="/admin/billing" class="block w-full text-center bg-green-600 text-white py-2 px-4 rounded hover:bg-green-700 transition">Billing Management</a>
            <a href="/admin/reports" class="block w-full text-center bg-purple-600 text-white py-2 px-4 rounded hover:bg-purple-700 transition">Generate Reports</a>
        </div>
    </div>
</div>

<!-- Storage Visualization -->
<div class="bg-white p-6 rounded-lg shadow-md mb-8">
    <h3 class="text-lg font-semibold text-gray-800 mb-4">Storage Utilization by Room</h3>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        <?php foreach ($rooms as $roomId => $room): ?>
            <div class="border rounded-lg p-4">
                <h4 class="font-semibold mb-2"><?php echo htmlspecialchars($room['name']); ?></h4>
                <div class="space-y-2">
                    <div class="flex justify-between text-sm">
                        <span>Storage Units:</span>
                        <span><?php echo $room['storage_units']; ?></span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span>Boxes:</span>
                        <span><?php echo $room['boxes']; ?></span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span>Total Positions:</span>
                        <span><?php echo $room['positions']; ?></span>
                    </div>
                    <div class="flex justify-between text-sm">
                        <span>Occupied:</span>
                        <span class="text-green-600"><?php echo $room['occupied']; ?></span>
                    </div>
                    <div class="w-full bg-gray-200 rounded-full h-2.5">
                        <div class="bg-green-600 h-2.5 rounded-full" style="width: <?php echo $room['positions'] > 0 ? ($room['occupied'] / $room['positions']) * 100 : 0; ?>%"></div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<!-- Revenue Chart -->
<div class="bg-white p-6 rounded-lg shadow-md">
    <h3 class="text-lg font-semibold text-gray-800 mb-4">Storage Utilization Chart</h3>
    <canvas id="storageChart" width="400" height="200"></canvas>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const ctx = document.getElementById('storageChart').getContext('2d');
    const storageChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: ['Occupied', 'Empty'],
            datasets: [{
                label: 'Positions',
                data: [<?php echo $occupiedPositions; ?>, <?php echo $emptyPositions; ?>],
                backgroundColor: [
                    'rgba(22, 163, 74, 0.7)',
                    'rgba(59, 130, 246, 0.7)'
                ],
                borderColor: [
                    'rgba(22, 163, 74, 1)',
                    'rgba(59, 130, 246, 1)'
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
});
</script>
