<?php
namespace Controllers;

use Services\StorageService;

class StorageController {
    public function storeSpecimen() {
        // Check authentication
        if (!isset($_SESSION['user']) || ($_SESSION['user']['role'] !== 'Admin' && $_SESSION['user']['role'] !== 'Staff')) {
            header('Location: /login');
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $barcode = $_POST['barcode'] ?? '';
            $clientId = $_POST['client_id'] ?? null;
            $positionId = $_POST['position_id'] ?? null;
            $sampleType = $_POST['sample_type'] ?? '';
            $volume = $_POST['volume'] ?? null;
            $diseaseOntology = $_POST['disease_ontology'] ?? null;

            try {
                StorageService::storeSpecimen($barcode, $clientId, $positionId, $sampleType, $volume, $diseaseOntology);
                $_SESSION['success'] = 'Specimen stored successfully!';
                header('Location: /admin/storage');
                exit;
            } catch (\Exception $e) {
                $_SESSION['error'] = $e->getMessage();
                header('Location: /admin/storage');
                exit;
            }
        }
    }

    public function search() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $barcode = $_POST['barcode'] ?? '';

            try {
                $result = StorageService::searchSpecimen($barcode);

                if ($result) {
                    $_SESSION['search_result'] = $result;
                } else {
                    $_SESSION['error'] = 'Specimen not found';
                }

                header('Location: /admin/storage');
                exit;
            } catch (\Exception $e) {
                $_SESSION['error'] = $e->getMessage();
                header('Location: /admin/storage');
                exit;
            }
        }
    }
}
