<?php
namespace Controllers;

use Services\StorageService;

class SearchController {
    public function search() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $barcode = $_POST['barcode'] ?? '';

            try {
                $result = StorageService::searchSpecimen($barcode);

                if ($result) {
                    $_SESSION['search_result'] = $result;
                } else {
                    $_SESSION['error'] = 'Specimen not found';
                }

                // Redirect based on user role
                if (isset($_SESSION['user'])) {
                    if ($_SESSION['user']['role'] === 'Admin' || $_SESSION['user']['role'] === 'Staff') {
                        header('Location: /admin');
                    } else {
                        header('Location: /client');
                    }
                } else {
                    header('Location: /');
                }
                exit;
            } catch (\Exception $e) {
                $_SESSION['error'] = $e->getMessage();

                // Redirect based on user role
                if (isset($_SESSION['user'])) {
                    if ($_SESSION['user']['role'] === 'Admin' || $_SESSION['user']['role'] === 'Staff') {
                        header('Location: /admin');
                    } else {
                        header('Location: /client');
                    }
                } else {
                    header('Location: /');
                }
                exit;
            }
        }
    }
}
