<?php
namespace Controllers;

class DashboardController {
    public function index() {
        // Check if user is logged in
        if (!isset($_SESSION['user'])) {
            header('Location: /login');
            exit;
        }

        // Redirect based on role
        $user = $_SESSION['user'];
        if ($user['role'] === 'Admin' || $user['role'] === 'Staff') {
            header('Location: /admin');
        } else {
            header('Location: /client');
        }
        exit;
    }
}
