<?php
namespace Controllers;

use Services\StorageService;
use Services\BillingService;

class ClientDispatchController {
    public function index() {
        // Check authentication
        if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'Client') {
            header('Location: /login');
            exit;
        }

        // Get client specimens
        $specimens = StorageService::getClientSpecimens($_SESSION['user']['client_id']);

        // Calculate client balance
        $balance = BillingService::calculateClientBalance($_SESSION['user']['client_id']);

        // Include view
        $content = __DIR__ . '/../views/client/dispatch.php';
        include __DIR__ . '/../views/layouts/client.php';
    }

    public function request() {
        // Check authentication
        if (!isset($_SESSION['user']) || $_SESSION['user']['role'] !== 'Client') {
            header('Location: /login');
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $specimenIds = $_POST['specimens'] ?? [];
            $shipTo = $_POST['ship_to'] ?? '';
            $contactPerson = $_POST['contact_person'] ?? '';
            $contactPhone = $_POST['contact_phone'] ?? '';
            $specialInstructions = $_POST['special_instructions'] ?? '';

            // In a real implementation, this would create a dispatch request in the database
            // For this demo, we'll just show a success message

            $_SESSION['success'] = 'Dispatch request submitted successfully!';
            header('Location: /client/dispatch');
            exit;
        }
    }
}
