<?php
namespace Controllers;

use Services\AuthService;

class AuthController {
    public function loginForm() {
        include __DIR__ . '/../views/auth/login.php';
    }

    public function registerForm() {
        include __DIR__ . '/../views/auth/register.php';
    }

    public function login() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $email = $_POST['email'] ?? '';
            $password = $_POST['password'] ?? '';

            try {
                $user = AuthService::loginUser($email, $password);
                $_SESSION['user'] = $user;

                // Redirect based on role
                if ($user['role'] === 'Admin' || $user['role'] === 'Staff') {
                    header('Location: /admin');
                } else {
                    header('Location: /client');
                }
                exit;
            } catch (\Exception $e) {
                $_SESSION['error'] = $e->getMessage();
                header('Location: /login');
                exit;
            }
        }
    }

    public function register() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $name = $_POST['name'] ?? '';
            $email = $_POST['email'] ?? '';
            $password = $_POST['password'] ?? '';
            $role = $_POST['role'] ?? 'Client';
            $clientId = $_POST['client_id'] ?? null;

            try {
                AuthService::registerUser($name, $email, $password, $role, $clientId);
                $_SESSION['success'] = 'Registration successful! Please login.';
                header('Location: /login');
                exit;
            } catch (\Exception $e) {
                $_SESSION['error'] = $e->getMessage();
                header('Location: /register');
                exit;
            }
        }
    }

    public function logout() {
        session_destroy();
        header('Location: /');
        exit;
    }
}
