<?php
require_once __DIR__ . '/../src/utils/Database.php';
require_once __DIR__ . '/../src/services/AuthService.php';
require_once __DIR__ . '/../src/services/BillingService.php';
require_once __DIR__ . '/../src/services/StorageService.php';

// Start session
session_start();

// Routing
$request = $_SERVER['REQUEST_URI'];
$method = $_SERVER['REQUEST_METHOD'];

// Simple router
$routes = [
    'GET' => [
        '/' => 'Controllers\HomeController@index',
        '/login' => 'Controllers\AuthController@loginForm',
        '/register' => 'Controllers\AuthController@registerForm',
        '/dashboard' => 'Controllers\DashboardController@index',
        '/admin' => 'Controllers\AdminController@index',
        '/admin/storage' => 'Controllers\AdminStorageController@index',
        '/admin/billing' => 'Controllers\AdminBillingController@index',
        '/admin/reports' => 'Controllers\AdminReportsController@index',
        '/admin/users' => 'Controllers\AdminUsersController@index',
        '/client' => 'Controllers\ClientController@index',
        '/client/specimens' => 'Controllers\ClientSpecimensController@index',
        '/client/billing' => 'Controllers\ClientBillingController@index',
        '/client/dispatch' => 'Controllers\ClientDispatchController@index',
        '/logout' => 'Controllers\AuthController@logout'
    ],
    'POST' => [
        '/login' => 'Controllers\AuthController@login',
        '/register' => 'Controllers\AuthController@register',
        '/store-specimen' => 'Controllers\StorageController@storeSpecimen',
        '/search' => 'Controllers\SearchController@search',
        '/admin/billing/add-rate' => 'Controllers\AdminBillingController@addRate',
        '/admin/billing/update-rate' => 'Controllers\AdminBillingController@updateRate',
        '/admin/reports/generate' => 'Controllers\AdminReportsController@generate',
        '/admin/users/add' => 'Controllers\AdminUsersController@add',
        '/client/dispatch' => 'Controllers\ClientDispatchController@request'
    ]
];

// Check if route exists
if (isset($routes[$method][$request])) {
    $route = $routes[$method][$request];
    list($controller, $method) = explode('@', $route);

    // Load controller
    require_once __DIR__ . '/../src/controllers/' . $controller . '.php';

    // Instantiate and call method
    $controllerInstance = new $controller();
    $controllerInstance->$method();
} else {
    // 404 Not Found
    http_response_code(404);
    echo "404 Not Found";
}
